<?php

include_once 'conexao.php';

class ModeloCarregamentoConta
{ 
	//Metodo mdlAddCliente serve para cadastrar Clientes na Base de dados
	static public function mdlAddCarregamentoConta($dados){
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO comprovativo (idUsuario,img,dataRegistro,estadoPagamento,banco) VALUES 
		(:idUsuario,:img,:dataRegistro,:estadoPagamento,:banco)");

		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":img", $dados["img"], PDO::PARAM_STR);
		$stmt->bindParam(":dataRegistro", $dados["dataRegistro"], PDO::PARAM_STR);
		$stmt->bindParam(":estadoPagamento", $dados["estadoPagamento"], PDO::PARAM_STR);
		$stmt->bindParam(":banco", $dados["banco"], PDO::PARAM_STR);

		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarTodosMeusCarregamentos(){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM comprovativo WHERE idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $_SESSION['ID_usuario'], PDO::PARAM_STR);
			$stmt->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosCarregamentosPorIdPagamento($idPagamento){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM comprovativo WHERE idComprovativo = :idPagamento");
			$stmt->bindParam(":idPagamento", $idPagamento, PDO::PARAM_STR);
			$stmt->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);

			return $resultado;

	}

	static public function mdlMostrarTodosCarregamentosPorEstadoPagamento($estado){
 
		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM comprovativo WHERE estadoPagamento= :estado");
			$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
			$stmt->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 

	static public function mdlActualizarEstadoDosComprovativoPorIdItem($idComprovativo, $CodReferencia,$valor,$dataRegistro,$estadoPagamento){


		$stmt = Conexao::conectar()->prepare("UPDATE comprovativo SET CodReferencia = :CodReferencia,
		 valor = :valor ,dataRegistro = :dataRegistro,estadoPagamento = :estadoPagamento,
		 funcionario= :funcionario  where idComprovativo = :cod");
		$stmt->bindParam(":cod", $idComprovativo, PDO::PARAM_STR);
		$stmt->bindParam(":CodReferencia", $CodReferencia, PDO::PARAM_STR);
		$stmt->bindParam(":valor", $valor, PDO::PARAM_STR);
		$stmt->bindParam(":dataRegistro", $dataRegistro, PDO::PARAM_STR);
		$stmt->bindParam(":estadoPagamento", $estadoPagamento, PDO::PARAM_STR);
		$stmt->bindParam(":funcionario", $_SESSION['ID_usuario'], PDO::PARAM_STR);
		$stmt ->execute();
		return "Ok";

	}

	static public function mdlActualizarEstadoDoComprovativoPorIdComprovativo($idComprovativo,$estado){
		
		$stmt = Conexao::conectar()->prepare("UPDATE comprovativo SET estadoPagamento = :estadoPagamento
		 where idComprovativo = :cod");
		$stmt->bindParam(":cod", $idComprovativo, PDO::PARAM_STR);
		$stmt->bindParam(":estadoPagamento", $estado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

}



  ?>